/****** Object:  StoredProcedure [dbo].[usp_Get_Admission_Event]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Admission_Event]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Admission_Event]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII	
-- Create date: 24.10.2012
-- Description:	Get admission event by ID.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Admission_Event] 
	@ID	INT = NULL,
	@DOMAIN_ID VARCHAR(50) = NULL,
	@PATIENT_UID UNIQUEIDENTIFIER = NULL,
	@VISTA_SITE_UID UNIQUEIDENTIFIER = NULL,
	@EVENT_IEN VARCHAR(20) = NULL,
	@EVENT_DATE_TIME DATETIME = NULL
AS
BEGIN
SET NOCOUNT ON

	IF (@ID IS NOT NULL)
		SELECT
			[AE].[ID],
			[AE].[ENTERED_DATE],
			[AE].[DOMAIN_ID],
			[AE].[IEN],
			[AE].[PATIENT_UID],
			[AE].[HAS_DISCHARGE],
			[AE].[BED_UID],				
			[AE].[WARD_UID],	
     		[AE].[VISTA_SITE_UID],			
			[AE].[ATND_NURSE_UID],
			[AE].[ADMISSION_DATE],
			[AE].[ENTERED_BY_UID],
			[TM].[CODE] AS [TYPE_OF_MOVEMENT_CODE],
			[TM].[CODE_SYSTEM] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM],
			[TM].[CODE_SYSTEM_NAME] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME],
			[TM].[DISPLAY_NAME] AS [TYPE_OF_MOVEMENT_DISPLAY_NAME]
		FROM ADMISSION_EVN AE 
			LEFT JOIN CONCEPT AS TM ON AE.TYPE_OF_MOVEMENT_ID = TM.ID	
		WHERE [AE].[ID] = @ID AND [AE].[DOMAIN_ID] = @DOMAIN_ID
	ELSE IF (@EVENT_IEN IS NOT NULL)
			SELECT TOP 1
				[AE].[ID],
				[AE].[ENTERED_DATE],
				[AE].[DOMAIN_ID],
				[AE].[IEN],
				[AE].[PATIENT_UID],
				[AE].[HAS_DISCHARGE],
				[AE].[BED_UID],				
				[AE].[WARD_UID],	
     			[AE].[VISTA_SITE_UID],			
				[AE].[ATND_NURSE_UID],
				[AE].[ADMISSION_DATE],
				[AE].[ENTERED_BY_UID],
				[TM].[CODE] AS [TYPE_OF_MOVEMENT_CODE],
				[TM].[CODE_SYSTEM] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM],
				[TM].[CODE_SYSTEM_NAME] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME],
				[TM].[DISPLAY_NAME] AS [TYPE_OF_MOVEMENT_DISPLAY_NAME]
			FROM ADMISSION_EVN AE 
				LEFT JOIN CONCEPT AS TM ON AE.TYPE_OF_MOVEMENT_ID = TM.ID	
			WHERE [AE].[VISTA_SITE_UID] = @VISTA_SITE_UID AND CAST([AE].[IEN] AS BIGINT) = CAST(@EVENT_IEN AS BIGINT)
			ORDER BY CAST([AE].[IEN] AS BIGINT) DESC
		ELSE 
			SELECT TOP 1
				[AE].[ID],
				[AE].[ENTERED_DATE],
				[AE].[DOMAIN_ID],
				[AE].[IEN],
				[AE].[PATIENT_UID],
				[AE].[HAS_DISCHARGE],
				[AE].[BED_UID],				
				[AE].[WARD_UID],	
     			[AE].[VISTA_SITE_UID],			
				[AE].[ATND_NURSE_UID],
				[AE].[ADMISSION_DATE],
				[AE].[ENTERED_BY_UID],
				[TM].[CODE] AS [TYPE_OF_MOVEMENT_CODE],
				[TM].[CODE_SYSTEM] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM],
				[TM].[CODE_SYSTEM_NAME] AS [TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME],
				[TM].[DISPLAY_NAME] AS [TYPE_OF_MOVEMENT_DISPLAY_NAME]
			FROM ADMISSION_EVN AE 
				LEFT JOIN CONCEPT AS TM ON AE.TYPE_OF_MOVEMENT_ID = TM.ID	
			WHERE [AE].[PATIENT_UID] = @PATIENT_UID AND [AE].[VISTA_SITE_UID] = @VISTA_SITE_UID AND [AE].[ADMISSION_DATE] < @EVENT_DATE_TIME
			ORDER BY CAST([AE].[IEN] AS BIGINT) DESC

END
GO
